/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.internal.recipeHandlers;

import craftedMods.lotr.recipes.api.utils.LOTRRecipeHandlerUtils;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.ItemStackSet;
import craftedMods.recipes.base.AbstractCraftingHelper;
import craftedMods.recipes.base.AbstractRecipe;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.CraftingGridRecipeHandler;
import craftedMods.recipes.base.ShapelessRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lotr.client.gui.LOTRGuiBarrel;
import lotr.common.LOTRMod;
import lotr.common.item.LOTRPoisonedDrinks;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@RegisteredHandler
public class BarrelRecipeHandler
extends CraftingGridRecipeHandler {
    private final BarrelRecipeHandlerCraftingHelper craftingHelper = new BarrelRecipeHandlerCraftingHelper();
    private final BarrelRecipeHandlerRecipeViewer recipeViewer = new BarrelRecipeHandlerRecipeViewer(this);
    public static final int[][] BARREL_STACKORDER = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    public BarrelRecipeHandler() {
        super("lotr.barrel", LOTRRecipeHandlerUtils::getBrewingRecipes);
    }

    public Collection<AbstractRecipe> loadSimpleStaticRecipes() {
        ArrayList<AbstractRecipe> ret = new ArrayList<AbstractRecipe>();
        for (IRecipe recipe : (Collection)this.recipesListGetter.get()) {
            if (recipe instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe shapelessOreRecipe = (ShapelessOreRecipe)recipe;
                ret.add((AbstractRecipe)new BrewingRecipe(shapelessOreRecipe.getInput(), shapelessOreRecipe.func_77571_b()));
                continue;
            }
            this.undefinedRecipeTypeFound(recipe, ret);
        }
        return ret;
    }

    public String getDisplayName() {
        return LOTRMod.barrel.func_149732_F();
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(AbstractRecipe recipe, EnumRecipeItemRole role) {
        return this.getSlotsForRecipeItems(recipe, role, BARREL_STACKORDER);
    }

    public BarrelRecipeHandlerCraftingHelper getCraftingHelper() {
        return this.craftingHelper;
    }

    public RecipeHandlerRecipeViewer<AbstractRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    public int getDefaultOrder() {
        return 4000;
    }

    public class BrewingRecipe
    extends ShapelessRecipe {
        public BrewingRecipe(Collection<?> ingredients, ItemStack result) {
            int i;
            super(ingredients, result);
            for (i = 0; i < 3; ++i) {
                this.add(new ItemStack(Items.field_151131_as), this.ingredients);
            }
            for (i = 0; i < 4; ++i) {
                ((ItemStackSet)this.results.get(0)).add((Object)new ItemStack(result.func_77973_b(), result.field_77994_a, result.func_77960_j() + i + 1));
            }
        }

        public boolean produces(ItemStack result) {
            if (!LOTRPoisonedDrinks.isDrinkPoisoned(result)) {
                for (ItemStackSet permutations : this.results) {
                    if (permutations == null) continue;
                    for (ItemStack permutation : permutations) {
                        if (result.func_77973_b() != permutation.func_77973_b()) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public ItemStack getResultReplacement(ItemStack defaultReplacement) {
            return defaultReplacement;
        }
    }

    public class BarrelRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<AbstractRecipe, BarrelRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public BarrelRecipeHandlerRecipeViewer(BarrelRecipeHandler handler) {
            super((RecipeHandler)handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(LOTRGuiBarrel.class);
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        public Collection<AbstractRecipe> getAllRecipes() {
            return ((BarrelRecipeHandler)this.handler).getStaticRecipes();
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiBarrel.class ? -2 : super.getOffsetX(guiClass);
        }

        public int getOffsetY(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiBarrel.class ? 104 : super.getOffsetY(guiClass);
        }
    }

    public class BarrelRecipeHandlerCraftingHelper
    extends AbstractCraftingHelper<AbstractRecipe> {
        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses(AbstractRecipe recipe) {
            return Arrays.asList(LOTRGuiBarrel.class);
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass, AbstractRecipe recipe) {
            return -11;
        }

        public int getOffsetY(Class<? extends GuiContainer> guiClass, AbstractRecipe recipe) {
            return 28;
        }
    }
}

